/*
 * Decompiled with CFR 0.152.
 */
package org.forsteri.ratatouille.content.compost_tower;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.NeoForgeCatnipServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.material.Fluid;
import org.forsteri.ratatouille.content.compost_tower.CompostTowerBlockEntity;

public class CompostTowerRenderer
extends SafeBlockEntityRenderer<CompostTowerBlockEntity> {
    public CompostTowerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(CompostTowerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        float capHeight = 0.2f;
        float tankHullWidth = 0.0078125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        Fluid[] sortedFluids = be.tankInventory.getSortedFluids();
        float accumulatedFluidHeight = 0.0f;
        float accumulatedGasHeight = 0.0f;
        for (int i = 0; i < sortedFluids.length; ++i) {
            float yEnd;
            float yStart;
            float ratio;
            Fluid fluid = sortedFluids[i];
            boolean isGas = fluid.getFluidType().isLighterThanAir();
            LerpedFloat levelValue = (isGas ? be.gasLevels : be.fluidLevels).get(fluid);
            if (levelValue == null || (ratio = levelValue.getValue(partialTicks)) < 1.0f / (512.0f * totalHeight)) continue;
            float fluidHeight = ratio * totalHeight;
            if (isGas) {
                yStart = totalHeight - accumulatedGasHeight - fluidHeight + capHeight + minPuddleHeight;
                yEnd = totalHeight - accumulatedGasHeight + capHeight + minPuddleHeight;
                accumulatedGasHeight += fluidHeight;
            } else {
                yStart = accumulatedFluidHeight + capHeight + minPuddleHeight;
                yEnd = accumulatedFluidHeight + fluidHeight + capHeight + minPuddleHeight;
                accumulatedFluidHeight += fluidHeight;
            }
            float xMin = tankHullWidth;
            float xMax = xMin + (float)be.radius - 2.0f * tankHullWidth;
            float zMin = tankHullWidth;
            float zMax = zMin + (float)be.radius - 2.0f * tankHullWidth;
            ms.pushPose();
            NeoForgeCatnipServices.FLUID_RENDERER.renderFluidBox(fluid.defaultFluidState(), xMin, yStart, zMin, xMax, yEnd, zMax, bufferSource, ms, light, false, true);
            ms.popPose();
        }
    }

    public boolean shouldRenderOffScreen(CompostTowerBlockEntity be) {
        return be.isController();
    }
}

